﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connectcampaigns/ConnectCampaigns_EXPORTS.h>
#include <aws/connectcampaigns/model/DialerConfig.h>
#include <aws/connectcampaigns/model/OutboundCallConfig.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ConnectCampaigns {
namespace Model {

/**
 * <p>An Amazon Connect campaign.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/Campaign">AWS
 * API Reference</a></p>
 */
class Campaign {
 public:
  AWS_CONNECTCAMPAIGNS_API Campaign() = default;
  AWS_CONNECTCAMPAIGNS_API Campaign(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECTCAMPAIGNS_API Campaign& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECTCAMPAIGNS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{

  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  Campaign& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  Campaign& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  Campaign& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetConnectInstanceId() const { return m_connectInstanceId; }
  inline bool ConnectInstanceIdHasBeenSet() const { return m_connectInstanceIdHasBeenSet; }
  template <typename ConnectInstanceIdT = Aws::String>
  void SetConnectInstanceId(ConnectInstanceIdT&& value) {
    m_connectInstanceIdHasBeenSet = true;
    m_connectInstanceId = std::forward<ConnectInstanceIdT>(value);
  }
  template <typename ConnectInstanceIdT = Aws::String>
  Campaign& WithConnectInstanceId(ConnectInstanceIdT&& value) {
    SetConnectInstanceId(std::forward<ConnectInstanceIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const DialerConfig& GetDialerConfig() const { return m_dialerConfig; }
  inline bool DialerConfigHasBeenSet() const { return m_dialerConfigHasBeenSet; }
  template <typename DialerConfigT = DialerConfig>
  void SetDialerConfig(DialerConfigT&& value) {
    m_dialerConfigHasBeenSet = true;
    m_dialerConfig = std::forward<DialerConfigT>(value);
  }
  template <typename DialerConfigT = DialerConfig>
  Campaign& WithDialerConfig(DialerConfigT&& value) {
    SetDialerConfig(std::forward<DialerConfigT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const OutboundCallConfig& GetOutboundCallConfig() const { return m_outboundCallConfig; }
  inline bool OutboundCallConfigHasBeenSet() const { return m_outboundCallConfigHasBeenSet; }
  template <typename OutboundCallConfigT = OutboundCallConfig>
  void SetOutboundCallConfig(OutboundCallConfigT&& value) {
    m_outboundCallConfigHasBeenSet = true;
    m_outboundCallConfig = std::forward<OutboundCallConfigT>(value);
  }
  template <typename OutboundCallConfigT = OutboundCallConfig>
  Campaign& WithOutboundCallConfig(OutboundCallConfigT&& value) {
    SetOutboundCallConfig(std::forward<OutboundCallConfigT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  Campaign& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  Campaign& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;

  Aws::String m_arn;

  Aws::String m_name;

  Aws::String m_connectInstanceId;

  DialerConfig m_dialerConfig;

  OutboundCallConfig m_outboundCallConfig;

  Aws::Map<Aws::String, Aws::String> m_tags;
  bool m_idHasBeenSet = false;
  bool m_arnHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_connectInstanceIdHasBeenSet = false;
  bool m_dialerConfigHasBeenSet = false;
  bool m_outboundCallConfigHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
};

}  // namespace Model
}  // namespace ConnectCampaigns
}  // namespace Aws
