/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.dashboard.splitApi.frontend.tree;

import com.intellij.execution.dashboard.RunDashboardGroup;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.platform.execution.dashboard.splitApi.RunDashboardServiceDto;
import com.intellij.platform.execution.dashboard.splitApi.frontend.RunDashboardGroupingRule;
import com.intellij.platform.execution.dashboard.splitApi.frontend.tree.FrontendRunConfigurationNode;
import com.intellij.platform.execution.dashboard.splitApi.frontend.tree.RunDashboardGroupImpl;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FolderDashboardGroupingRule
implements RunDashboardGroupingRule {
    @NonNls
    private static final String NAME = "FolderDashboardGroupingRule";

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @Nullable
    public RunDashboardGroup getGroup(FrontendRunConfigurationNode node) {
        RunDashboardServiceDto runConfiguration = node.getService();
        String folderName = runConfiguration.getFolderName();
        if (folderName != null) {
            return new FolderDashboardGroup(node.getProject(), folderName, folderName, AllIcons.Nodes.Folder);
        }
        return null;
    }

    public static final class FolderDashboardGroup
    extends RunDashboardGroupImpl<String> {
        private final Project myProject;

        public FolderDashboardGroup(Project project, String value, String name, Icon icon) {
            super(value, name, icon);
            this.myProject = project;
        }

        public Project getProject() {
            return this.myProject;
        }
    }
}

