/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.toolkit;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.langs.utils.NamesKt;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.settings.RuleSetting;
import ai.grazie.rules.settings.SettingGroup;
import ai.grazie.rules.settings.TextStyle;
import ai.grazie.rules.toolkit.PosHighlighting;
import ai.grazie.rules.toolkit.Selectioner;
import ai.grazie.rules.toolkit.StructuralWrapper;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.Parameter;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class LanguageToolkit {
    private final Language language;
    private final Supplier<List<Rule>> publishedRules;
    private static final Map<Language, LanguageToolkit> instances = new ConcurrentHashMap<Language, LanguageToolkit>();

    protected LanguageToolkit(Language language) {
        this.language = language;
        this.publishedRules = Suppliers.memoize(() -> {
            List<Rule> rules = this.createRules();
            for (Rule rule : rules) {
                rule.setLanguage(language);
            }
            return rules;
        });
    }

    public Language language() {
        return this.language;
    }

    public List<Rule> publishedRules() {
        return this.publishedRules.get();
    }

    protected abstract List<Rule> createRules();

    @Nullable
    public abstract PosHighlighting posHighlight(Node var1);

    public abstract Selectioner selectioner();

    @Nullable
    public StructuralWrapper getStructuralWrapper() {
        return null;
    }

    @ApiStatus.Internal
    public List<Rule> webRules() {
        return ((StreamEx)StreamEx.of(this.publishedRules()).filter(r -> r.isRuleEnabledByDefault(TextStyle.Unspecified, new RuleClient(this){

            @Override
            public boolean suggestCurlyPunctuationByDefault() {
                return true;
            }
        }))).toList();
    }

    public abstract String getRuleDescriptionLinkText();

    protected static RuleSetting ruleSetting(Map<String, Rule> map, String id, Parameter ... parameters) {
        return new RuleSetting(map.get(id), parameters);
    }

    public List<SettingGroup> getSettings(RuleClient client) {
        return List.of();
    }

    public List<Parameter> allParameters(RuleClient client) {
        return StreamEx.of(this.getSettings(client)).flatCollection(g -> g.settings()).flatMap(s -> StreamEx.of((Object)s).append(s instanceof RuleSetting ? ((RuleSetting)s).getSubSettings() : List.of())).select(Parameter.class).toList();
    }

    public static LanguageToolkit forLanguage(Language language) {
        return instances.computeIfAbsent(language, __ -> {
            String code = language.getIso().toString();
            String className = "ai.grazie.rules." + code + "." + NamesKt.getEnglishName((Language)language) + "Toolkit";
            try {
                return (LanguageToolkit)Class.forName(className).getField("INSTANCE").get(null);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

