/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.snapshots.get;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.snapshots.SnapshotInfo;

@PublicApi(since="1.0.0")
public class GetSnapshotsResponse
extends ActionResponse
implements ToXContentObject {
    private static final ConstructingObjectParser<GetSnapshotsResponse, Void> GET_SNAPSHOT_PARSER = new ConstructingObjectParser(GetSnapshotsResponse.class.getName(), true, args -> new GetSnapshotsResponse((List)args[0]));
    private final List<SnapshotInfo> snapshots;

    public GetSnapshotsResponse(List<SnapshotInfo> snapshots) {
        this.snapshots = Collections.unmodifiableList(snapshots);
    }

    GetSnapshotsResponse(StreamInput in) throws IOException {
        super(in);
        this.snapshots = Collections.unmodifiableList(in.readList(SnapshotInfo::new));
    }

    public List<SnapshotInfo> getSnapshots() {
        return this.snapshots;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.snapshots);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("snapshots");
        for (SnapshotInfo snapshotInfo : this.snapshots) {
            snapshotInfo.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static GetSnapshotsResponse fromXContent(XContentParser parser) throws IOException {
        return (GetSnapshotsResponse)((Object)GET_SNAPSHOT_PARSER.parse(parser, null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GetSnapshotsResponse that = (GetSnapshotsResponse)((Object)o);
        return Objects.equals(this.snapshots, that.snapshots);
    }

    public int hashCode() {
        return Objects.hash(this.snapshots);
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    static {
        GET_SNAPSHOT_PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> ((SnapshotInfo.SnapshotInfoBuilder)SnapshotInfo.SNAPSHOT_INFO_PARSER.apply(p, c)).build(), new ParseField("snapshots", new String[0]));
    }
}

