/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.util.ClassNameComparator;
import org.assertj.core.util.Strings;
import org.assertj.core.util.introspection.ClassUtils;

abstract class TypeHolder<T> {
    private static final Comparator<Class<?>> DEFAULT_CLASS_COMPARATOR = ClassNameComparator.INSTANCE;
    protected final Map<Class<?>, T> typeHolder;

    public TypeHolder() {
        this(DEFAULT_CLASS_COMPARATOR);
    }

    public TypeHolder(Comparator<Class<?>> comparator) {
        this.typeHolder = new TreeMap(Objects.requireNonNull(comparator, "Comparator must not be null"));
    }

    public T get(Class<?> clazz) {
        Class<?> relevantType = this.getRelevantClass(clazz);
        return relevantType == null ? null : (T)this.typeHolder.get(relevantType);
    }

    public void put(Class<?> clazz, T entity) {
        this.typeHolder.put(clazz, entity);
    }

    public boolean hasEntity(Class<?> type) {
        return this.get(type) != null;
    }

    public boolean isEmpty() {
        return this.typeHolder.isEmpty();
    }

    public void clear() {
        this.typeHolder.clear();
    }

    public Stream<Map.Entry<Class<?>, T>> entityByTypes() {
        return this.typeHolder.entrySet().stream();
    }

    private Class<?> getRelevantClass(Class<?> cls) {
        Set<Class<?>> keys = this.typeHolder.keySet();
        if (keys.contains(cls)) {
            return cls;
        }
        for (Class<?> superClass : ClassUtils.getAllSuperclasses(cls)) {
            if (!keys.contains(superClass)) continue;
            return superClass;
        }
        for (Class<?> interfaceClass : ClassUtils.getAllInterfaces(cls)) {
            if (!keys.contains(interfaceClass)) continue;
            return interfaceClass;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeHolder that = (TypeHolder)o;
        return this.typeHolder.equals(that.typeHolder);
    }

    public int hashCode() {
        return Objects.hash(this.typeHolder);
    }

    public String toString() {
        List registeredEntitiesDescription = this.typeHolder.entrySet().stream().map(TypeHolder::formatRegisteredEntity).collect(Collectors.toList());
        return "{%s}".formatted(Strings.join(registeredEntitiesDescription).with(", "));
    }

    private static <T> String formatRegisteredEntity(Map.Entry<Class<?>, T> entry) {
        return "%s -> %s".formatted(entry.getKey().getSimpleName(), entry.getValue());
    }
}

